//
//  MCReportRegion.h
//  Composer
//
//  Created by Alykhan Jetha on 04/06/2005.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportElement.h"

extern NSString *MCReportLayoutElementMovedInRegionNotification;

@interface MCReportRegion : MCReportElement {
	BOOL isInDragDestinationMode;
	
	NSRect rubberbandRect;
    NSSet *rubberbandViews;
    NSPoint pasteCascadeDelta;

	unsigned int rubberbandIsDeselecting;
	unsigned int knobsHidden;

    NSRect verticalRulerLineRect;
    NSRect horizontalRulerLineRect;
	
	NSMutableArray *selectedViews;
	
}

- (void)commonInit;

// makes a copy of the subview and puts it on the undo stack
- (void)registerSubviewForUndo:(MCReportElement *)anElement;


- (void)selectAndTrackMouseWithEvent:(NSEvent *)theEvent; 
- (void)selectView:(NSView *)aView byExtendingSelection:(BOOL)flag ensureRegionIsFirstResponder:(BOOL)first;
- (void)selectView:(NSView *)aView byExtendingSelection:(BOOL)flag;
- (void)selectView:(NSView *)aView;
- (void)deselectView:(NSView *)aView;
- (BOOL)isViewSelected:(NSView *)aView;
- (void)clearSelection;
- (NSMutableArray *)selectedViews;
- (void)setSelectedViews:(NSArray *)views;
- (void)didChangeSelection; // subclass responsibility


// subclasses can override to overrule deletion
- (BOOL)canDeleteView:(MCReportElement *)elem;
- (void)didDeleteView:(MCReportElement *)elem;

- (void)insertElement:(MCReportElement *)element inMiddle:(BOOL)middle select:(BOOL)flag;
- (void)pushElement:(MCReportElement *)aElement backwardsInSubviewStack:(NSArray *)subviews;


/* ============================================= Dragging =================================== */
- (unsigned int)dragOperationForDraggingInfo:(id <NSDraggingInfo>)sender; 
- (void)dragReportElementWithEvent:(NSEvent *)theEvent;



/* ============================================= Rulers ===================================== */
- (void)updateRulers; 
- (void)beginEchoingMoveToRulers:(NSRect)echoRect;
- (void)continueEchoingMoveToRulers:(NSRect)echoRect; 
- (void)stopEchoingMoveToRulers; 

/* ============================================= Knobs ====================================== */

- (void)trackKnob:(int)knob ofView:(MCReportElement *)view withEvent:(NSEvent *)theEvent;
- (void)moveSelectedViewsWithEvent:(NSEvent *)theEvent;

/* ============================================= Drawing ==================================== */

- (void)drawFill;
- (void)drawSelectedFrame;
- (void)drawUnselectedFrame;
- (void)drawCurrentRegionFrame;
- (void)drawCurrentDragFrame;


- (BOOL)isCurrentRegion;


/* ====================================== Target / Action ================================== */

- (IBAction)sizeToFitMaximumHeight:(id)sender;
- (IBAction)sizeToFitMinimumHeight:(id)sender;
- (IBAction)changeSelectedElementsToBox:(id)sender;

- (IBAction)performDelete:(id)sender;
- (IBAction)performPaste:(id)sender;

- (IBAction)insertBox:(id)sender;
- (IBAction)insertTextArea:(id)sender;
- (IBAction)insertDynamicTextArea:(id)sender;
- (IBAction)insertTable:(id)sender;
- (IBAction)insertImage:(id)sender;
- (IBAction)insertVerticalLine:(id)sender;
- (IBAction)insertHorizontalLine:(id)sender;
- (IBAction)insertStrip:(id)sender;
- (IBAction)insertCheckmark:(id)sender;
- (IBAction)insertColorBlob:(id)sender;
- (IBAction)addColumns:(id)sender;
- (IBAction)insertPageNumberArea:(id)sender;
- (IBAction)changeSelectedElementsToTextArea:(id)sender;
- (IBAction)changeSelectedElementsToBox:(id)sender;
- (IBAction)changeSelectedElementsToImage:(id)sender;
- (IBAction)changeSelectedElementsToCheckmark:(id)sender;
- (IBAction)changeSelectedElementsToColorBlob:(id)sender;
- (IBAction)alignLeftEdges:(id)sender;
- (IBAction)alignRightEdges:(id)sender;
- (IBAction)alignTopEdges:(id)sender;
- (IBAction)alignBottomEdges:(id)sender;
- (IBAction)pushElementBackwards:(id)sender;
- (IBAction)pullElementForward:(id)sender;
- (IBAction)matchHeights:(id)sender;
- (IBAction)matchWidths:(id)sender;
- (IBAction)sizeToFitText:(id)sender;

- (IBAction)performMoveLeft:(id)sender; 
- (IBAction)performMoveRight:(id)sender; 
- (IBAction)performMoveUp:(id)sender;
- (IBAction)performMoveDown:(id)sender;


@end


NSRect MCRLRectFromPoints(NSPoint point1, NSPoint point2);

